<?php /* Template Name: Home Page Template */ ?>

<?php get_header(); ?>
<?php $homepage_settings = get_homepage_settings(); ?>
<?php $howitworks_settings = get_howitworks_settings(); ?>
<?php $predictionbonus_settings = get_predictionbonus_settings(); ?>
<?php $gadgetsgiveaway_settings = get_gadgetsgiveaway_settings(); ?>
<?php $termsconditions_settings = get_termsconditions_settings(); ?>
<?php $schedule_settings = get_schedule_settings(); ?>
<?php $leaguetable_settings = get_leaguetable_settings(); ?>
<?php $playoffs_settings = get_playoffs_settings(); ?>
<?php $leaderboard_settings = get_leaderboard_settings(); ?>
<?php $prediction_settings = get_prediction_settings(); ?>
<?php $gameweeks_settings = get_gameweeks_settings(); ?>
<?php $registration_popup_settings = get_registration_popup_settings(); ?>
<?php $timezone_settings = get_timezone_settings(); ?>

	<main class="main" role="main">
		<div class="main-wrapper">
			<div class="main-title">
				<h1>
					<?php echo nl2br($homepage_settings['page_title_1'][0]); ?>
				</h1>
				<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/header-title-in.png" class="header">
				<h2>
					<?php echo nl2br($homepage_settings['page_sub_title'][0]); ?>
				</h2>
			</div>
			<div class="main-content">
				<div class="content-left">
					<div class="content-prize-container">
					</div>
					<div class="content-btn-container vs">
						<!-- <div data-tab-item="5" class="tabs-btn">
							<div class="tabs-btn-img"><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/prediction-bonus-icon.png"></div>
							<div class="tabs-btn tabs-btn-left prediction-btn"><?php echo $homepage_settings['prediction_bonus'][0]; ?></div>
						</div>
						<div data-tab-item="6" class="tabs-btn">
							<div class="tabs-btn-img"><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/giveaway-gadgets-icon.png"></div>
							<div class="tabs-btn-left gadgets-btn"><?php echo $homepage_settings['gadgets_giveaway'][0]; ?></div>
						</div> -->
					</div>
				</div>
				

				<input type="hidden" id="gameweeks_activate" value="<?php echo $gameweeks_settings['game_weeks_activate'][0]; ?>">
				<div class="content-right">
					<div class="tabs-main desktop">
						<div>
							<ul class="tabs-ul">
								<li data-tab-item="1" class="active">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/how-it-works-icon.png" class="tab-icon inactive">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/how-it-works-icon-hover.png" class="tab-icon active">
									<span class="tabs-icon-label active"><?php echo $homepage_settings['right_navigation_button_1'][0]; ?></span>
									<span class="tabs-icon-label inactive"><?php echo $homepage_settings['right_navigation_button_1'][0]; ?></span>
								</li>
								<li data-tab-item="2" class="">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/prediction-icon.png" class="tab-icon inactive">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/prediction-icon-hover.png" class="tab-icon active">
									<span class="tabs-icon-label active"><?php echo $homepage_settings['right_navigation_button_2'][0]; ?></span>
									<span class="tabs-icon-label inactive"><?php echo $homepage_settings['right_navigation_button_2'][0]; ?></span>
								</li>
								<li data-tab-item="3" class="game-weeks">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/schedule-icon.png" class="tab-icon inactive">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/schedule-icon-hover.png" class="tab-icon active">
									<span class="tabs-icon-label active"><?php echo $homepage_settings['right_navigation_button_3'][0]; ?></span>
									<span class="tabs-icon-label inactive"><?php echo $homepage_settings['right_navigation_button_3'][0]; ?></span>
								</li>
								<li data-tab-item="4" class="">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/leaderboard-icon.png" class="tab-icon inactive">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/leaderboard-icon-hover.png" class="tab-icon active">
									<span class="tabs-icon-label active"><?php echo $homepage_settings['right_navigation_button_4'][0]; ?></span>
									<span class="tabs-icon-label inactive"><?php echo $homepage_settings['right_navigation_button_4'][0]; ?></span>
								</li>
							</ul>
							<div class="go-to-wrapper">
								<div class="go-to-btn to-down" style=""></div>
							</div>
						</div>
					</div>

					<div class="tabs-main mobile">
						<div>
							<ul class="tabs-ul">
								<li data-tab-item="1" class="active menu-icon-1">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/how-it-works-icon-mobile.png" class="tab-icon inactive">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/how-it-works-icon-mobile-hover.png" class="tab-icon active">
									<span class="tabs-icon-label active"><?php echo $homepage_settings['right_navigation_button_1'][0]; ?></span>
									<span class="tabs-icon-label inactive"><?php echo $homepage_settings['right_navigation_button_1'][0]; ?></span>
								</li>
								<li data-tab-item="2" class="menu-icon-2">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/prediction-icon-mobile.png" class="tab-icon inactive">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/prediction-icon-mobile-hover.png" class="tab-icon active">
									<span class="tabs-icon-label active"><?php echo $homepage_settings['right_navigation_button_2'][0]; ?></span>
									<span class="tabs-icon-label inactive"><?php echo $homepage_settings['right_navigation_button_2'][0]; ?></span>
								</li>
								<li data-tab-item="3" class="game-weeks menu-icon-3">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/schedule-icon-mobile.png" class="tab-icon inactive">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/schedule-icon-mobile-hover.png" class="tab-icon active">
									<span class="tabs-icon-label active"><?php echo $homepage_settings['right_navigation_button_3'][0]; ?></span>
									<span class="tabs-icon-label inactive"><?php echo $homepage_settings['right_navigation_button_3'][0]; ?></span>
								</li>
								<li data-tab-item="4" class="menu-icon-4">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/leaderboard-icon-mobile.png" class="tab-icon inactive">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/tab-icons/leaderboard-icon-mobile-hover.png" class="tab-icon active">
									<span class="tabs-icon-label active"><?php echo $homepage_settings['right_navigation_button_4'][0]; ?></span>
									<span class="tabs-icon-label inactive"><?php echo $homepage_settings['right_navigation_button_4'][0]; ?></span>
								</li>
							</ul>
							<div class="go-to-wrapper">
								<div class="go-to-btn to-down" style=""></div>
							</div>
						</div>
					</div>

					
					<div class="tabs-content-wrapper">
						<!-- How It Works Section -->
						<div data-tab-item="1" class="tab-content tab-1 active">
							<div class="tab-content-title"><?php echo $howitworks_settings['section_title'][0]; ?></div>
							<div class="scroll-pane how-it-works">
								<div class="scroll-pane-content-wrapper">
									<?php $counter = 0; ?>
									<?php while ($counter < $howitworks_settings['list'][0]) { ?>
										<div class="hiw-item">
											<div>
												<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/no<?php echo trim($counter+1)?>.png">											</div>
											<div>
												<div class="hiw-name"><?php echo $howitworks_settings['list_'.$counter.'_item'][0]; ?></div>
												<div class="hiw-desc"><?php echo $howitworks_settings['list_'.$counter.'_description'][0]; ?></div>
											</div>
										</div>
									<?php $counter++; ?>				
									<?php } ?>
									<?php if ($prediction_settings['prediction_activate'][0] == 1) { ?>
									<?php } ?>
								</div>
							</div>
						</div>

						<!-- Prediction Section -->
						<div data-tab-item="2" class="tab-content tab-2">
							<div class="tab-content-title">GAME WEEK <span class="remain-round"></span> PREDICTION</div>
							<ul class="sub-tabs-ul rd-ul">
								<?php
									$current_date = date('Y-m-d H:i:s');
									$current_date_format_iso = date("c");
								?>
								<?php $counter = 0; ?>
								<?php $ongoing_ctr = 0; ?>
								<?php if ($prediction_settings['rounds'][0]) { ?>
									<?php while ($counter < $prediction_settings['rounds'][0]) { ?>
										<?php
											$round_prediction_start_date = "";
											$round_prediction_start_date_format = "";
											$round_prediction_start_date_format_iso = "";
											$round_prediction_end_date_format_iso = "";

											$round_prediction_start_date = $prediction_settings['rounds_'.$counter.'_prediction_start_date'][0];
											$round_prediction_end_date = $prediction_settings['rounds_'.$counter.'_prediction_end_date'][0];
											
											if ($round_prediction_start_date) {
												$round_prediction_start_date_format = date("F j, g:i A",strtotime($round_prediction_start_date));
											}
											//ISO 8601
											if ($round_prediction_start_date) {
												$round_prediction_start_date_format_iso = date("c",strtotime($round_prediction_start_date));
											}
											if ($round_prediction_end_date) {
												$round_prediction_end_date_format_iso = date("c",strtotime($round_prediction_end_date));
											}

											$date_difference = "";
											$date_difference = abs(strtotime($round_prediction_start_date) - strtotime($current_date));

											// // Declare and define two dates 
											// $date1 = strtotime($current_date);  
											// $date2 = strtotime($round_start_date);  
											  
											// // Formulate the Difference between two dates 
											// $diff = abs($date2 - $date1);  

											// //$years = floor($diff / (365*60*60*24));
											// //$months = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));  
											// $days 		= floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24) / (60*60*24)); 
											// $hours 		= floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24 - $days*60*60*24) / (60*60));  
											// $minutes 	= floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24 - $days*60*60*24 - $hours*60*60) / 60);  
											// $seconds 	= floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24 - $days*60*60*24 - $hours*60*60 - $minutes*60));  
											  
											// // Print the result 
											// printf("%d years, %d months, %d days, %d hours, %d minutes, %d seconds", $years, $months, $days, $hours, $minutes, $seconds); 

											// if ($current_date < $prediction_settings['rounds_'.$counter.'_prediction_start_date'][0]) {

											// } else if ($current_date > $prediction_settings['rounds_'.$counter.'_prediction_end_date'][0]) {

											// }
											$addClass = "";
											$data_rd_end_date = "";
											if ($current_date < $round_prediction_start_date || empty($prediction_settings['rounds_'.$counter.'_prediction_start_date'][0])) {
												$addClass = "round-countdown";
											} else {
												if ($current_date < $round_prediction_end_date) {
													$addClass = "ongoing ongoing-".($ongoing_ctr+1);
													$ongoing_ctr++;
													//$data_rd_end_date = 'data-rd-start-date="'.$round_prediction_end_date_format_iso.'"';
												}
											}
											$data_attr = "";
											if (empty($prediction_settings['rounds_'.$counter.'_prediction_start_date'][0])) {
												$data_attr = 'data-available-msg="'.$prediction_settings['round_availability_popup_message_2'][0].'"';
												$data_msg_type = 'data-msg-type="2"';
												$data_date_difference = '';
											} else if ($current_date < $round_prediction_start_date) {
												$data_attr = 'data-available-msg="'.$prediction_settings['round_availability_popup_message'][0].'"';
												$data_msg_type = 'data-msg-type="1"';
												$data_date_difference = 'data-rd-date-difference="'.$date_difference.'"';
											}
										?>
										<li data-date-translation="<?php echo $prediction_settings['rounds_'.$counter.'_date_translation'][0]; ?>" data-title-translation="<?php echo $prediction_settings['rounds_'.$counter.'_round_tab_title_translation'][0]; ?>" data-rd-item="<?php echo $counter+1; ?>" <?php echo $data_date_difference; ?> data-rd-start-date="<?php echo $round_prediction_start_date_format_iso; ?>" data-rd-end-date="<?php echo $round_prediction_end_date_format_iso; ?>" <?php echo $data_attr; ?> <?php echo $data_msg_type; ?> class="<?php if ($counter == 0) { ?>active<?php } ?> <?php echo $addClass; ?>"><?php echo $prediction_settings['rounds_'.$counter.'_round_tab_title'][0]; ?></li>
									<?php $counter++; ?>				
									<?php } ?>
								<?php } ?>
							</ul>
							<div class="sub-tabs-main-title">
								<span class="first-round act">
									<?php echo nl2br($prediction_settings['intro_text'][0]); ?>
								</span>
								<span class="last-round">
									<?php echo nl2br($prediction_settings['intro_text_qf_sf_and_f'][0]); ?>
								</span>
							</div>
							
							<div class="sub-tab-content-wrapper">
								<div class="sub-tabs-title">
									<div class="cell">DATE (GMT+8)</div>
									<div class="cell">HOME TEAM</div>
									<div class="cell">1</div>
									<div class="cell">X</div>
									<div class="cell">2</div>
									<div class="cell">AWAY TEAM</div>
								</div>
								<?php $counter = 0; ?>
								<?php if ($prediction_settings['rounds'][0]) { ?>
									<?php while ($counter < $prediction_settings['rounds'][0]) { ?>
									<?php
											$next_round_prediction_start_date = "";
											$next_round_prediction_end_date = "";
											$next_round_prediction_start_date_format = "";
											$next_round_prediction_start_date_format_iso = "";
											$next_round_prediction_end_date_format_iso = "";

											$next_round_prediction_start_date = $prediction_settings['rounds_'.($counter+1).'_prediction_start_date'][0];
											$next_round_prediction_end_date = $prediction_settings['rounds_'.($counter+1).'_prediction_end_date'][0];

											if ($next_round_prediction_start_date) {
												$next_round_prediction_start_date_format = date("F j, g:i A",strtotime($next_round_prediction_start_date));
											}

											//ISO 8601
											if ($next_round_prediction_start_date) {
												$next_round_prediction_start_date_format_iso = date("c",strtotime($next_round_prediction_start_date));
											}
											if ($next_round_prediction_end_date) {
												$next_round_prediction_end_date_format_iso = date("c",strtotime($next_round_prediction_end_date));
											}

											$addClass = "";
											$addBtnClass = "";
											if ($current_date > $prediction_settings['rounds_'.$counter.'_prediction_end_date'][0] && !empty($prediction_settings['rounds_'.$counter.'_prediction_end_date'][0])) {
												$addClass = "round-expired";
											} else {
												if (empty($prediction_settings['rounds_'.$counter.'_prediction_start_date'][0]) || empty($prediction_settings['rounds_'.$counter.'_prediction_end_date'][0])) {
													$addClass = "round-countdown";
												}
											}
											if (!empty($next_round_prediction_start_date) && !empty($next_round_prediction_end_date)) {
												if (($current_date < $next_round_prediction_end_date) && ($current_date > $next_round_prediction_start_date)) {
													$addBtnClass = "ongoing";
												}
											}

											$data_attr = "";
											if (empty($prediction_settings['rounds_'.$counter.'_prediction_start_date'][0])) {
												$data_attr = 'data-available-msg="'.$prediction_settings['round_availability_popup_message_2'][0].'"';
												$data_msg_type = 'data-msg-type="2"';
											} else if ($current_date < $next_round_prediction_start_date) {
												$data_attr = 'data-available-msg="'.$prediction_settings['round_availability_popup_message'][0].'"';
												$data_msg_type = 'data-msg-type="1"';
											}
									?>
										<div data-rd-item="<?php echo $counter+1; ?>" data-penalties="<?php echo $prediction_settings['rounds_'.$counter.'_activate_penalties'][0]; ?>" class="sub-tab-content rd-content rd-content-<?php echo $counter+1; ?> <?php if ($counter == 0) { ?>active<?php } ?> <?php echo $addClass; ?>">
											<div class="scroll-pane">
												<div class="scroll-pane-content-wrapper">
													<div class="prediction-list-wrapper">
													<?php if ($prediction_settings['rounds_'.$counter.'_matches'][0]){ ?>
														<form id="round-form-<?php echo $counter+1; ?>">
															<?php $counter1 = 0; ?>
															<?php while ($counter1 < $prediction_settings['rounds_'.$counter.'_matches'][0]) { ?>
															<?php
																$home_team_info = get_post_meta($prediction_settings['rounds_'.$counter.'_matches_'.$counter1.'_home_team'][0]);
		        												$home_team_logo_attr = wp_get_attachment_image_src($home_team_info['team_logo'][0], 'full');
		        												$away_team_info = get_post_meta($prediction_settings['rounds_'.$counter.'_matches_'.$counter1.'_away_team'][0]);
		        												$away_team_logo_attr = wp_get_attachment_image_src($away_team_info['team_logo'][0], 'full');

		        												$home_team_winner_class = "";
		        												$home_team_data_tab_item = "";
		        												if ($prediction_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "home_team") {
		        													$home_team_winner_class = "tabs-btn";
		        													$home_team_data_tab_item = "data-tab-item='3'";
		        												}
		        												$away_team_winner_class = "";
		        												$away_team_data_tab_item = "";
		        												if ($prediction_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "away_team") {
		        													$away_team_winner_class = "tabs-btn";
		        													$away_team_data_tab_item = "data-tab-item='3'";
		        												}
		        											?>
																<div class="prediction-teams-wrapper active" id="<?php echo $counter1+1; ?>">	

																	<div class="date"><?php echo $prediction_settings['rounds_'.$counter.'_matches_'.$counter1.'_date'][0]; ?></div>
																	<div class="prediction-team prediction-team-1 <?php if ($prediction_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "home_team") { ?>match-winner<?php } ?>">
																		<div class="inline team-img"><img src="<?php echo $home_team_logo_attr[0]; ?>" class="team-logo"></div>
																		<div class="inline team-name <?php echo $home_team_winner_class; ?>" <?php echo $home_team_data_tab_item; ?>><?php echo $home_team_info['team_name'][0]; ?></div>
																	</div>
																	
																	<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">
																		<div class="team-radio">
																			<input type="radio" class="predict-radio-btn score" data-score-radio="<?php echo $counter1+1; ?>" form-num="<?php echo $counter+1; ?>" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>" value="<?php echo $home_team_info['team_name'][0]; ?>" <?php if ($current_date > $prediction_settings['rounds_'.$counter.'_prediction_end_date'][0] && !empty($prediction_settings['rounds_'.$counter.'_prediction_end_date'][0])) { ?>disabled<?php } ?>>
																		</div>
																	</div>
																	<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">	
																		<div class="team-radio">
																			<input type="radio" class="predict-radio-btn draw" data-radio="<?php echo $counter1+1; ?>" form-num="<?php echo $counter+1; ?>" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>" value="DRAW" <?php if ($current_date > $prediction_settings['rounds_'.$counter.'_prediction_end_date'][0] && !empty($prediction_settings['rounds_'.$counter.'_prediction_end_date'][0])) { ?>disabled<?php } ?>>
																		</div>
																	</div>
																	<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">	
																		<div class="team-radio">
																			<input type="radio" class="predict-radio-btn score" data-score-radio="<?php echo $counter1+1; ?>" form-num="<?php echo $counter+1; ?>" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>" value="<?php echo $away_team_info['team_name'][0]; ?>" <?php if ($current_date > $prediction_settings['rounds_'.$counter.'_prediction_end_date'][0] && !empty($prediction_settings['rounds_'.$counter.'_prediction_end_date'][0])) { ?>disabled<?php } ?>>
																		</div>
																	</div>
																		
																	<div class="prediction-team prediction-team-2 <?php if ($prediction_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "away_team") { ?>match-winner<?php } ?>">
																		<div class="inline team-img"><img src="<?php echo $away_team_logo_attr[0]; ?>" class="team-logo"></div>
																		<div class="inline team-name <?php echo $away_team_winner_class; ?>" <?php echo $away_team_data_tab_item; ?>><?php echo $away_team_info['team_name'][0]; ?></div>
																	</div>

																</div>
																<?php if($counter+1 != 1 && $counter+1 != 2){ ?>
																<div class="prediction-teams-wrapper penalties penalties-<?php echo $counter1+1; ?>">
																	<?php //Penalties ?>

																	<div class="date">PENALTIES</div>
																	<div class="prediction-team prediction-team-1 <?php if ($prediction_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "home_team") { ?>match-winner<?php } ?>">
																		<div class="inline team-img"><img src="<?php echo $home_team_logo_attr[0]; ?>" class="team-logo"></div>
																		<div class="inline team-name <?php echo $home_team_winner_class; ?>" <?php echo $home_team_data_tab_item; ?>><?php echo $home_team_info['team_name'][0]; ?></div>
																	</div>
																	
																	<div class="radio-wrapper penalty" id="<?php echo $counter1+1; ?>">
																		<div class="team-radio">
																			<input type="radio" class="predict-radio-btn" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>-penalties" value="<?php echo $home_team_info['team_name'][0]; ?>" <?php if ($current_date > $prediction_settings['rounds_'.$counter.'_prediction_end_date'][0] && !empty($prediction_settings['rounds_'.$counter.'_prediction_end_date'][0])) { ?>disabled<?php } ?>>
																		</div>
																	</div>
																	<div class="radio-wrapper penalty" id="<?php echo $counter1+1; ?>">	
																		<div class="team-radio">
																			<input type="radio" class="predict-radio-btn" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>-penalties" value="DRAW" <?php if ($current_date > $prediction_settings['rounds_'.$counter.'_prediction_end_date'][0] && !empty($prediction_settings['rounds_'.$counter.'_prediction_end_date'][0])) { ?>disabled<?php } ?>>
																		</div>
																	</div>
																	<div class="radio-wrapper penalty" id="<?php echo $counter1+1; ?>">	
																		<div class="team-radio">
																			<input type="radio" class="predict-radio-btn" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>-penalties" value="<?php echo $away_team_info['team_name'][0]; ?>" <?php if ($current_date > $prediction_settings['rounds_'.$counter.'_prediction_end_date'][0] && !empty($prediction_settings['rounds_'.$counter.'_prediction_end_date'][0])) { ?>disabled<?php } ?>>
																		</div>
																	</div>
																		
																	<div class="prediction-team prediction-team-2 <?php if ($prediction_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "away_team") { ?>match-winner<?php } ?>">
																		<div class="inline team-img"><img src="<?php echo $away_team_logo_attr[0]; ?>" class="team-logo"></div>
																		<div class="inline team-name <?php echo $away_team_winner_class; ?>" <?php echo $away_team_data_tab_item; ?>><?php echo $away_team_info['team_name'][0]; ?></div>
																	</div>
																</div>	
																<?php } ?>
																
															<?php $counter1++; ?>				
															<?php } ?>
														</form>
													<?php  } else if ($prediction_settings['rounds_'.$counter.'_matches_qf'][0]){ ?>
													<div class="sub-tabs-title-qf">
														<div class="cell"><?php echo $prediction_settings['date_label'][0]; ?></div>
														<div class="cell"><?php echo $prediction_settings['home_team'][0]; ?></div>
														<div class="cell"><?php echo $prediction_settings['h_score'][0]; ?></div>
														<div class="cell"><?php echo $prediction_settings['a_score'][0]; ?></div>
														<div class="cell"><?php echo $prediction_settings['away_team'][0]; ?></div>
													</div>
													<form id="round-form-5">
														<?php $counter1 = 0; ?>
															<?php while ($counter1 < $prediction_settings['rounds_'.$counter.'_matches_qf'][0]) { ?>
															<?php
																$home_team_info = get_post_meta($prediction_settings['rounds_'.$counter.'_matches_qf_'.$counter1.'_home_team'][0]);
		        												$home_team_logo_attr = wp_get_attachment_image_src($home_team_info['team_logo'][0], 'full');
		        												$away_team_info = get_post_meta($prediction_settings['rounds_'.$counter.'_matches_qf_'.$counter1.'_away_team'][0]);
		        												$away_team_logo_attr = wp_get_attachment_image_src($away_team_info['team_logo'][0], 'full');
		        											?>
																<div class="prediction-teams-wrapper active" id="<?php echo $counter1+1; ?>">	

																	<div class="date"><?php echo $prediction_settings['rounds_'.$counter.'_matches_qf_'.$counter1.'_date'][0]; ?></div>
																	<div class="prediction-team prediction-team-1 <?php if ($prediction_settings['rounds_'.$counter.'_matches_'.$counter1.'_home_team'][0] == "home_team") { ?>match-winner<?php } ?>">
																		<div class="inline team-img"><img src="<?php echo $home_team_logo_attr[0]; ?>" class="team-logo"></div>
																		<div class="inline team-name"><?php echo $home_team_info['team_name'][0]; ?></div>
																	</div>
																	
																	<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">
																		<div class="team-radio">
																			<select class="predict-radio-btn score" data-team-name="<?php echo $home_team_info['team_name_in_en'][0]; ?>" data-score-radio="<?php echo $counter1+1; ?>" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>">
																				<option value="0">0</option>
																				<?php 
																					$h_score  = $prediction_settings['rounds_'.$counter.'_matches_qf_'.$counter1.'_h_score'][0];
																					$indv_h_score = explode(",", $h_score);
																					foreach ($indv_h_score as $value) { 
																				?>
																				<option value="<?php echo $value; ?>"><?php echo $value; ?></option>
																				<?php } ?>
																			</select>
																		</div>
																	</div>

																	<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">	
																		<div class="team-radio">
																			<select class="predict-radio-btn score" data-team-name="<?php echo $away_team_info['team_name_in_en'][0]; ?>" data-score-radio="<?php echo $counter1+1; ?>" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>">
																				<option value="0">0</option>
																				<?php 
																					$a_score  = $prediction_settings['rounds_'.$counter.'_matches_qf_'.$counter1.'_a_score'][0];
																					$indv_a_score = explode(",", $a_score);
																					foreach ($indv_a_score as $value) { 
																				?>
																				<option value="<?php echo $value; ?>"><?php echo $value; ?></option>
																				<?php } ?>
																			</select>
																		</div>
																	</div>
																		
																	<div class="prediction-team prediction-team-2 <?php if ($prediction_settings['rounds_'.$counter.'_matches_qf_'.$counter1.'_away_team'][0] == "away_team") { ?>match-winner<?php } ?>">
																		<div class="inline team-img"><img src="<?php echo $away_team_logo_attr[0]; ?>" class="team-logo"></div>
																		<div class="inline team-name"><?php echo $away_team_info['team_name'][0]; ?></div>
																	</div>

																</div>
																
															<?php $counter1++; ?>				
															<?php } ?>
													</form>	
													<?php } else if ($prediction_settings['rounds_'.$counter.'_matches_sf'][0]){ ?>
													<form id="round-form-6">
														<?php $counter1 = 0; ?>
															<?php while ($counter1 < $prediction_settings['rounds_'.$counter.'_matches_sf'][0]) { ?>
															<?php
																$home_team_info = get_post_meta($prediction_settings['rounds_'.$counter.'_matches_sf_'.$counter1.'_team_a'][0]);
		        												$away_team_info = get_post_meta($prediction_settings['rounds_'.$counter.'_matches_sf_'.$counter1.'_team_b'][0]);
		        												$home_team_logo_attr = wp_get_attachment_image_src($home_team_info['team_logo'][0], 'full');
		        												$away_team_logo_attr = wp_get_attachment_image_src($away_team_info['team_logo'][0], 'full');
		        											?>	
																<div class="round-form-6-container">
																	<hr class="right-border">
																	<hr class="left-border">
																	<div class="title"><?php echo $prediction_settings['rounds_'.$counter.'_matches_sf_'.$counter1.'_title'][0]; ?></div>
																	<div class="prediction-team prediction-team-1">
																		<div class="inline team-name"><?php echo $home_team_info['team_name'][0]; ?></div>
																		<div class="inline team-img"><img src="<?php echo $home_team_logo_attr[0]; ?>" class="team-logo"></div>
																	</div>
																	<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">
																		<div class="team-radio">
																			<select class="predict-radio-btn score" data-team-name="<?php echo $home_team_info['team_name_in_en'][0]; ?>" data-score-radio="<?php echo $counter1+1; ?>" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>">
																				<option value="0">0</option>
																				<?php 
																					$team_a_score  = $prediction_settings['rounds_'.$counter.'_matches_sf_'.$counter1.'_team_a_score'][0];
																					$indv_a_score = explode(",", $team_a_score);
																					foreach ($indv_a_score as $value) { 
																				?>
																				<option value="<?php echo $value; ?>"><?php echo $value; ?></option>
																				<?php } ?>
																			</select>
																		</div>
																	</div>
																	<div class="vs">VS</div>
																	<div class="prediction-team prediction-team-2">
																		<div class="inline team-name"><?php echo $away_team_info['team_name'][0]; ?></div>
																		<div class="inline team-img"><img src="<?php echo $away_team_logo_attr[0]; ?>" class="team-logo"></div>
																	</div>
																	<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">
																		<div class="team-radio">
																			<select class="predict-radio-btn score" data-team-name="<?php echo $away_team_info['team_name_in_en'][0]; ?>" data-score-radio="<?php echo $counter1+1; ?>" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>">
																				<option value="0">0</option>
																				<?php 
																					$team_b_score  = $prediction_settings['rounds_'.$counter.'_matches_sf_'.$counter1.'_team_b_score'][0];
																					$indv_b_score = explode(",", $team_b_score);
																					foreach ($indv_b_score as $value) { 
																				?>
																				<option value="<?php echo $value; ?>"><?php echo $value; ?></option>
																				<?php } ?>
																			</select>
																		</div>
																	</div>
																</div>
																<?php $counter1++; ?>				
															<?php } ?>

													</form>				
													<?php } else if ($prediction_settings['rounds_'.$counter.'_matches_finals'][0]){ ?>
													<form id="round-form-7">
														<?php $counter1 = 0; ?>
															<?php while ($counter1 < $prediction_settings['rounds_'.$counter.'_matches_finals'][0]) { ?>
															<?php
																$home_team_info = get_post_meta($prediction_settings['rounds_'.$counter.'_matches_finals_'.$counter1.'_team_a'][0]);
		        												$away_team_info = get_post_meta($prediction_settings['rounds_'.$counter.'_matches_finals_'.$counter1.'_team_b'][0]);
																$home_team_logo_attr = wp_get_attachment_image_src($home_team_info['team_logo'][0], 'full');
		        												$away_team_logo_attr = wp_get_attachment_image_src($away_team_info['team_logo'][0], 'full');
		        											?>	
																<div class="round-form-7-container">
																	<hr class="right-border">
																	<hr class="left-border">
																	<div class="title"><?php echo $prediction_settings['rounds_'.$counter.'_matches_finals_'.$counter1.'_title'][0]; ?></div>
																	<div class="prediction-team prediction-team-1">
																		<div class="inline team-name"><?php echo $home_team_info['team_name'][0]; ?></div>
																		<div class="inline team-img"><img src="<?php echo $home_team_logo_attr[0]; ?>" class="team-logo"></div>
																	</div>
																	<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">
																		<div class="team-radio">
																			<select class="predict-radio-btn score" data-team-name="<?php echo $home_team_info['team_name_in_en'][0]; ?>" data-score-radio="<?php echo $counter1+1; ?>" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>">
																				<option value="0">0</option>
																				<?php 
																					$team_a_score  = $prediction_settings['rounds_'.$counter.'_matches_finals_'.$counter1.'_team_a_score'][0];
																					$indv_a_score = explode(",", $team_a_score);
																					foreach ($indv_a_score as $value) { 
																				?>
																				<option value="<?php echo $value; ?>"><?php echo $value; ?></option>
																				<?php } ?>
																			</select>
																		</div>
																	</div>
																	<div class="vs">VS</div>
																	<div class="prediction-team prediction-team-2">
																		<div class="inline team-name"><?php echo $away_team_info['team_name'][0]; ?></div>
																		<div class="inline team-img"><img src="<?php echo $away_team_logo_attr[0]; ?>" class="team-logo"></div>
																	</div>
																	<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">
																		<div class="team-radio">
																			<select class="predict-radio-btn score" data-team-name="<?php echo $away_team_info['team_name_in_en'][0]; ?>" data-score-radio="<?php echo $counter1+1; ?>" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>">
																				<option value="0">0</option>
																				<?php 
																					$team_b_score  = $prediction_settings['rounds_'.$counter.'_matches_finals_'.$counter1.'_team_b_score'][0];
																					$indv_b_score = explode(",", $team_b_score);
																					foreach ($indv_b_score as $value) { 
																				?>
																				<option value="<?php echo $value; ?>"><?php echo $value; ?></option>
																				<?php } ?>
																			</select>
																		</div>
																	</div>
																</div>
																<?php $counter1++; ?>				
															<?php } ?>
													</form>	
													<?php } else { ?>
														<div class="no-available-message padding-30-10"><?php echo $prediction_settings['no_available_match_message'][0]; ?></div>
													<?php } ?>
														<div class="matches_number" data-matches="<?php echo $counter1; ?>"></div>
													</div>
												</div>
											</div>
											<div class="content-inner-btn-container margin-10 hidden">
												<a class="content-btn btn-submit-prediction" href="javascript:void(0)" data-round-num="<?php echo $counter+1; ?>"><?php echo $prediction_settings['submit_button'][0]; ?><span class="fnt-size-14"> GW<?php echo $counter+1; ?> PREDICTION</span></a>
											</div>
											<div class="prediction-error-message">
												<?php echo $prediction_settings['incomplete_prediction_message'][0]; ?>
											</div>
										</div>
										<?php $counter++; ?>		
									<?php } ?>
								<?php } ?>
							</div>
						</div>

						<div class="sub-tabs-time-remain">
								<div class="sub-tabs-time-remain-calc">
									<span id="remaining-day">
										<span class="remaining-value">0</span>
										<span class="remaining-label">D</span>
									</span>
									<span id="remaining-hr">
										<span class="remaining-value">0</span>
										<span class="remaining-label">H</span>
									</span>
									<span id="remaining-min">
										<span class="remaining-value">0</span>
										<span class="remaining-label">M</span>

									</span>
									<span id="remaining-sec">
										<span class="remaining-value">0</span>
										<span class="remaining-label">S</span>
									</span>
								</div>
								<div class="sub-tabs-time-remain-title">BEFORE GAME WEEK <span class="remain-round"></span> CLOSES</div>
						</div>

						<!-- Game Weeks Result Section -->
						<div data-tab-item="3" class="tab-content tab-3">
							<div class="tab-content-title">GAME WEEKS</div>
							<ul class="sub-tabs-ul rd-ul">
								
								<?php $counter = 0; ?>
								<?php $ongoing_ctr = 0; ?>
								<?php if ($gameweeks_settings['rounds'][0]) { ?>
									<?php while ($counter < $gameweeks_settings['rounds'][0]) { ?>
										<li data-rd-item="<?php echo $counter+1; ?>" class="<?php if ($counter == 0) { ?>active<?php } ?>">
											<?php echo $gameweeks_settings['rounds_'.$counter.'_round_tab_title'][0]; ?>	
										</li>
									<?php $counter++; ?>				
									<?php } ?>
								<?php } ?>
							</ul>
							
							<div class="sub-tab-content-wrapper">
								<?php $counter = 0; ?>
								<?php if ($gameweeks_settings['rounds'][0]) { ?>
									<div class="sub-tabs-title-game-weeks">
										<div class="cell">DATE (GMT+8)</div>
										<div class="cell">HOME TEAM</div>
										<div class="cell">1</div>
										<div class="cell">X</div>
										<div class="cell">2</div>
										<div class="cell">AWAY TEAM</div>
									</div>
									<?php while ($counter < $gameweeks_settings['rounds'][0]) { ?>
										<div data-rd-item="<?php echo $counter+1; ?>" data-attr="<?php echo $gameweeks_settings['rounds_'.$counter.'_activate'][0] ?>" class="sub-tab-content game-weeks rd-content rd-content-<?php echo $counter+1; ?> <?php if ($counter == 0) { ?>active<?php } ?> <?php echo $addClass; ?>">
										<?php if ($gameweeks_settings['rounds_'.$counter.'_activate'][0] == "1") { ?>
											<input type="hidden" class="hide-title" value="0">
											<div class="scroll-pane">
												<div class="scroll-pane-content-wrapper">
													<div class="prediction-list-wrapper">
													<?php if ($gameweeks_settings['rounds_'.$counter.'_matches'][0]) { ?>
															<?php $counter1 = 0; ?>
															<?php while ($counter1 < $gameweeks_settings['rounds_'.$counter.'_matches'][0]) { ?>
															<?php
																$home_team_info = get_post_meta($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_home_team'][0]);
		        												$home_team_logo_attr = wp_get_attachment_image_src($home_team_info['team_logo'][0], 'full');
		        												$away_team_info = get_post_meta($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_away_team'][0]);
		        												$away_team_logo_attr = wp_get_attachment_image_src($away_team_info['team_logo'][0], 'full');

		        												$home_team_winner_class = "";
		        												$home_team_data_tab_item = "";
		        												if ($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "home_team") {
		        													$home_team_winner_class = "tabs-btn";
		        													$home_team_data_tab_item = "data-tab-item='3'";
		        												}
		        												$away_team_winner_class = "";
		        												$away_team_data_tab_item = "";
		        												if ($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "away_team") {
		        													$away_team_winner_class = "tabs-btn";
		        													$away_team_data_tab_item = "data-tab-item='3'";
		        												}
		        											?>
																<div class="prediction-teams-wrapper">

																	<div class="date"><?php echo $gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_date'][0]; ?></div>

																	<div class="prediction-team prediction-team-1 <?php if ($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "home_team") { ?>match-winner<?php } ?>">
																		<div class="inline team-img"><img src="<?php echo $home_team_logo_attr[0]; ?>" class="team-logo"></div>
																		<div class="inline team-name <?php echo $home_team_winner_class; ?>" <?php echo $home_team_data_tab_item; ?>><?php echo $home_team_info['team_name'][0]; ?></div>
																	</div>
																	
																	<div class="radio-wrapper">
																		<div class="team-radio">
																			<input type="radio" class="predict-radio-btn score" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>" <?php if ($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "one") { ?> checked="checked" <?php } ?>>
																		</div>
																	</div>
																	<div class="radio-wrapper">	
																		<div class="team-radio">
																			<input type="radio" class="predict-radio-btn draw" data-radio="<?php echo $counter1+1; ?>" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>" <?php if ($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "draw") { ?>checked="checked"<?php } ?>>
																		</div>
																	</div>
																	<div class="radio-wrapper">	
																		<div class="team-radio">
																			<input type="radio" class="predict-radio-btn score" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>" <?php if ($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "two") { ?>checked="checked"<?php } ?>>
																		</div>
																	</div>
																		
																	<div class="prediction-team prediction-team-2 <?php if ($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "away_team") { ?>match-winner<?php } ?>">
																		<div class="inline team-img"><img src="<?php echo $away_team_logo_attr[0]; ?>" class="team-logo"></div>
																		<div class="inline team-name <?php echo $away_team_winner_class; ?>" <?php echo $away_team_data_tab_item; ?>><?php echo $away_team_info['team_name'][0]; ?></div>
																	</div>

																</div>	
																<?php if($gameweeks_settings['rounds_'.$counter.'_activate_penalties'][0] == "1") { ?>
																<?php if($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_penalties'][0]){?>
																<?php if($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_penalties'][0] != "none"){?>
																<div class="prediction-teams-wrapper penalties penalties-<?php echo $counter1+1; ?>">
																	<?php //Penalties ?>

																	<div class="date">PENALTIES</div>
																	<div class="prediction-team prediction-team-1 <?php if ($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "home_team") { ?>match-winner<?php } ?>">
																		<div class="inline team-img"><img src="<?php echo $home_team_logo_attr[0]; ?>" class="team-logo"></div>
																		<div class="inline team-name <?php echo $home_team_winner_class; ?>" <?php echo $home_team_data_tab_item; ?>><?php echo $home_team_info['team_name'][0]; ?></div>
																	</div>
																	
																	<div class="radio-wrapper">
																		<div class="team-radio">
																			<input type="radio" class="predict-radio-btn" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>-penalties" <?php if ($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_penalties'][0] == "one") { ?>checked="checked"<?php } ?>>
																		</div>
																	</div>
																	<div class="radio-wrapper">	
																		<div class="team-radio">
																			<input type="radio" class="predict-radio-btn" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>-penalties" <?php if ($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_penalties'][0] == "draw") { ?>checked="checked"<?php } ?>>
																		</div>
																	</div>
																	<div class="radio-wrapper">	
																		<div class="team-radio">
																			<input type="radio" class="predict-radio-btn" name="game-week-<?php echo $counter+1; ?>-match-<?php echo $counter1+1; ?>-penalties" <?php if ($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_penalties'][0] == "two") { ?>checked="checked"<?php } ?>>
																		</div>
																	</div>
																		
																	<div class="prediction-team prediction-team-2 <?php if ($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_winner'][0] == "away_team") { ?>match-winner<?php } ?>">
																		<div class="inline team-img"><img src="<?php echo $away_team_logo_attr[0]; ?>" class="team-logo"></div>
																		<div class="inline team-name <?php echo $away_team_winner_class; ?>" <?php echo $away_team_data_tab_item; ?>><?php echo $away_team_info['team_name'][0]; ?></div>
																	</div>
																</div>
																<?php } ?>
																<?php } ?>
																<?php } ?>
															<?php $counter1++; ?>				
														<?php } ?>
													<?php  } else if ($gameweeks_settings['rounds_'.$counter.'_matches_qf'][0]){ ?>
													<div class="sub-tabs-title-qf">
														<div class="cell"><?php echo $prediction_settings['date_label'][0]; ?></div>
														<div class="cell"><?php echo $prediction_settings['home_team'][0]; ?></div>
														<div class="cell"><?php echo $prediction_settings['h_score'][0]; ?></div>
														<div class="cell"><?php echo $prediction_settings['a_score'][0]; ?></div>
														<div class="cell"><?php echo $prediction_settings['away_team'][0]; ?></div>
													</div>
													<form id="round-form-5">
														<?php $counter1 = 0; ?>
														<?php while ($counter1 < $gameweeks_settings['rounds_'.$counter.'_matches_qf'][0]) { ?>
														<?php
															$home_team_info = get_post_meta($gameweeks_settings['rounds_'.$counter.'_matches_qf_'.$counter1.'_home_team'][0]);
	        												$home_team_logo_attr = wp_get_attachment_image_src($home_team_info['team_logo'][0], 'full');
	        												$away_team_info = get_post_meta($gameweeks_settings['rounds_'.$counter.'_matches_qf_'.$counter1.'_away_team'][0]);
	        												$away_team_logo_attr = wp_get_attachment_image_src($away_team_info['team_logo'][0], 'full');
	        											?>
															<div class="prediction-teams-wrapper active" id="<?php echo $counter1+1; ?>">	

																<div class="date"><?php echo $gameweeks_settings['rounds_'.$counter.'_matches_qf_'.$counter1.'_date'][0]; ?></div>
																<div class="prediction-team prediction-team-1 <?php if ($gameweeks_settings['rounds_'.$counter.'_matches_'.$counter1.'_home_team'][0] == "home_team") { ?>match-winner<?php } ?>">
																	<div class="inline team-img"><img src="<?php echo $home_team_logo_attr[0]; ?>" class="team-logo"></div>
																	<div class="inline team-name"><?php echo $home_team_info['team_name'][0]; ?></div>
																</div>
																
																<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">
																	<div class="team-radio">
																		<?php echo $gameweeks_settings['rounds_'.$counter.'_matches_qf_'.$counter1.'_h_score'][0]; ?>
																	</div>
																</div>

																<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">	
																	<div class="team-radio">
																		<?php echo $gameweeks_settings['rounds_'.$counter.'_matches_qf_'.$counter1.'_a_score'][0]; ?>
																	</div>
																</div>
																	
																<div class="prediction-team prediction-team-2 <?php if ($gameweeks_settings['rounds_'.$counter.'_matches_qf_'.$counter1.'_away_team'][0] == "away_team") { ?>match-winner<?php } ?>">
																	<div class="inline team-img"><img src="<?php echo $away_team_logo_attr[0]; ?>" class="team-logo"></div>
																	<div class="inline team-name"><?php echo $away_team_info['team_name'][0]; ?></div>
																</div>

															</div>
														<?php $counter1++; ?>				
														<?php } ?>
													</form>
												<?php } else if ($gameweeks_settings['rounds_'.$counter.'_matches_sf'][0]){ ?>
													<form id="round-form-6">
														<?php $counter1 = 0; ?>
														<?php while ($counter1 < $gameweeks_settings['rounds_'.$counter.'_matches_sf'][0]) { ?>
														<?php
															$home_team_info = get_post_meta($gameweeks_settings['rounds_'.$counter.'_matches_sf_'.$counter1.'_team_a'][0]);
	        												$away_team_info = get_post_meta($gameweeks_settings['rounds_'.$counter.'_matches_sf_'.$counter1.'_team_b'][0]);
															$home_team_logo_attr = wp_get_attachment_image_src($home_team_info['team_logo'][0], 'full');
		        											$away_team_logo_attr = wp_get_attachment_image_src($away_team_info['team_logo'][0], 'full');
	        											?>	
															<div class="round-form-6-container">
																<hr class="right-border">
																<hr class="left-border">
																<div class="title"><?php echo $gameweeks_settings['rounds_'.$counter.'_matches_sf_'.$counter1.'_title'][0]; ?></div>
																<div class="prediction-team prediction-team-1">
																	<div class="inline team-name"><?php echo $home_team_info['team_name'][0]; ?></div>
																	<div class="inline team-img"><img src="<?php echo $home_team_logo_attr[0]; ?>" class="team-logo"></div>
																</div>
																<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">
																	<div class="team-radio">
																		<?php echo $gameweeks_settings['rounds_'.$counter.'_matches_sf_'.$counter1.'_team_a_score'][0]; ?>
																	</div>
																</div>
																<div class="vs">VS</div>
																<div class="prediction-team prediction-team-2">
																	<div class="inline team-name"><?php echo $away_team_info['team_name'][0]; ?></div>
																	<div class="inline team-img"><img src="<?php echo $away_team_logo_attr[0]; ?>" class="team-logo"></div>
																</div>
																<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">
																	<div class="team-radio">
																		<?php echo $gameweeks_settings['rounds_'.$counter.'_matches_sf_'.$counter1.'_team_b_score'][0]; ?>
																	</div>
																</div>
															</div>
															<?php $counter1++; ?>				
														<?php } ?>
													</form>
													<?php } else if ($gameweeks_settings['rounds_'.$counter.'_matches_finals'][0]){ ?>
													<form id="round-form-7">
														<?php $counter1 = 0; ?>
														<?php while ($counter1 < $gameweeks_settings['rounds_'.$counter.'_matches_finals'][0]) { ?>
														<?php
															$home_team_info = get_post_meta($gameweeks_settings['rounds_'.$counter.'_matches_finals_'.$counter1.'_team_a'][0]);
	        												$away_team_info = get_post_meta($gameweeks_settings['rounds_'.$counter.'_matches_finals_'.$counter1.'_team_b'][0]);
															$home_team_logo_attr = wp_get_attachment_image_src($home_team_info['team_logo'][0], 'full');
		        											$away_team_logo_attr = wp_get_attachment_image_src($away_team_info['team_logo'][0], 'full');
	        											?>	
															<div class="round-form-7-container">
																<hr class="right-border">
																<hr class="left-border">
																<div class="title"><?php echo $gameweeks_settings['rounds_'.$counter.'_matches_finals_'.$counter1.'_title'][0]; ?></div>
																<div class="prediction-team prediction-team-1">
																	<div class="inline team-name"><?php echo $home_team_info['team_name'][0]; ?></div>
																	<div class="inline team-img"><img src="<?php echo $home_team_logo_attr[0]; ?>" class="team-logo"></div>
																</div>
																<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>">
																	<div class="team-radio">
																		<?php echo $gameweeks_settings['rounds_'.$counter.'_matches_finals_'.$counter1.'_team_a_score'][0]; ?>
																	</div>
																</div>
																<div class="vs">VS</div>
																<div class="prediction-team prediction-team-2">
																	<div class="inline team-name"><?php echo $away_team_info['team_name'][0]; ?></div>
																	<div class="inline team-img"><img src="<?php echo $away_team_logo_attr[0]; ?>" class="team-logo"></div>
																</div>
																<div class="radio-wrapper main" id="<?php echo $counter1+1; ?>"> 
																	<div class="team-radio">
																		<?php echo $gameweeks_settings['rounds_'.$counter.'_matches_finals_'.$counter1.'_team_b_score'][0]; ?>
																	</div>
																</div>
															</div>	
															<?php $counter1++; ?>				
														<?php } ?>
													</form>
													<?php } else { ?>
														<div class="no-available-message padding-30-10"><?php echo $gameweeks_settings['no_available_match_message'][0]; ?></div>
													<?php } ?>
													</div>
												</div>
											</div>
										<?php } else { ?>
											<input type="hidden" class="hide-title" value="1">
											<h1><?php echo $gameweeks_settings['rounds_'.$counter.'_tbd'][0]; ?></h1>
										<?php } ?>	
										</div>
										<?php $counter++; ?>				
									<?php } ?>
								<?php } ?>
							</div>
						</div>

						<!-- Terms and Conditions Section -->
						<div data-tab-item="4" class="tab-content tab-4 terms-title">
							<div class="tab-content-title"><?php echo $termsconditions_settings['section_title'][0]; ?></div>
							<div class="scroll-pane">
								<div class="scroll-pane-content-wrapper">
									<?php $counter = 0; ?>
									<ul class="tab-ul-list">
									<?php while ($counter < $termsconditions_settings['list'][0]) { ?>
										<li><?php echo $termsconditions_settings['list_'.$counter.'_item'][0]; ?>
											<div class="table-type-1">
											<?php 
												//$table = json_decode($termsconditions_settings['list_'.$counter.'_table'][0]);
												$tnc_settings_info = get_page_by_path('terms-and-conditions');
												$table = get_field('list_'.$counter.'_table',$tnc_settings_info->ID);
												include('table-template-gadgets.php');
											?>
											</div>
										</li>
									<?php $counter++; ?>				
									<?php } ?>
									</ul>
								</div>
							</div>
							
						</div>

						<!-- Terms and Conditions Section -->
						<div data-tab-item="7" class="tab-content tab-7 terms-title">
							<div class="tab-content-title"><?php echo $termsconditions_settings['section_title'][0]; ?></div>
							<div class="scroll-pane">
								<div class="scroll-pane-content-wrapper">
									<?php $counter = 0; ?>
									<ul class="tab-ul-list">
									<?php while ($counter < $termsconditions_settings['list'][0]) { ?>
										<li><?php echo $termsconditions_settings['list_'.$counter.'_item'][0]; ?>
											<div class="table-type-1">
											<?php 
												//$table = json_decode($termsconditions_settings['list_'.$counter.'_table'][0]);
												$tnc_settings_info = get_page_by_path('terms-and-conditions');
												$table = get_field('list_'.$counter.'_table',$tnc_settings_info->ID);
												include('table-template-gadgets.php');
											?>
											</div>
										</li>
									<?php $counter++; ?>				
									<?php } ?>
									</ul>
								</div>
							</div>
							
						</div>

						<div class="overlay">
							<div class="overlay-box overlay-loading"></div>
							<div class="overlay-box overlay-submit">
								<div class="close">X</div>
								<div><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/dafabet-logo-small.png"></div>
								<form id="main-form" class="">
									<div class="main-form-note"><?php echo $registration_popup_settings['registration_popup_intro_text'][0]; ?></div>
									<div class="main-form-field-wrapper">
										<input class="main-form-field username-field" type="text" name="dafabet_username" placeholder="<?php echo $registration_popup_settings['registration_popup_username_label'][0]; ?>" value="" maxlength="40">
										<p class="input-error-message username-error"><?php echo $registration_popup_settings['registration_popup_username_error_message'][0]; ?></p>
									</div>
									<p>NO ACCOUNT YET? <a target="_blank" href="<?php echo $registration_popup_settings['registration_popup_click_here_link'][0]; ?>" id="click_here">CLICK HERE</a> TO JOIN NOW</p>
									<div class="main-form-field-wrapper">
										<input class="main-form-field email-field" type="text" name="email_address" placeholder="<?php echo $registration_popup_settings['registration_popup_email_label'][0]; ?>" value="">
										<p class="input-error-message email-error"><?php echo $registration_popup_settings['registration_popup_email_error_message'][0]; ?></p>
									</div>
									<input type="hidden" name="round-num" id="selected-round" value="">
									<input type="hidden" name="query-string" id="query-string" value="<?php echo $_SERVER['QUERY_STRING']; ?>">
									<button type="button" id="btn-submit-email" class="overlay-btn"><?php echo $registration_popup_settings['registration_popup_submit_button'][0]; ?></button>	
								</form>
							</div>

							<div class="overlay-box overlay-bet">
								<div class="close">X</div>
								<div><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/dafabet-logo-small.png"></div>
								<div class="overlay-bet-message"><?php echo $registration_popup_settings['thank_you_popup_message_message_1'][0]; ?></div>
								<div class="overlay-bet-message"><?php echo $registration_popup_settings['thank_you_popup_message_message_2'][0]; ?></div>
								<a href="<?php echo $registration_popup_settings['thank_you_popup_message_bet_now_link'][0]; ?>" id="btn-overlay-bet" target="_blank" class="overlay-btn"><?php echo $registration_popup_settings['thank_you_popup_message_bet_now_button'][0]; ?></a>	
							</div>
						</div>
						<?php if($_GET['override'] == "OGDEVTEST"){} else {  ?>
						<div class="overlay-countdown">
							<div class="overlay-box overlay-countdown-timer">
								<div class="overlay-countdown-message"><span class="round-tab-title-translation"></span> <span class="msg"><?php echo $prediction_settings['round_availability_popup_message'][0]; ?></span></div>
								<div class="overlay-countdown-date"></div>
								<div class="overlay-countdown-calc">
									<div id="countdown-day">
										<div class="countdown-value">0</div>
										<div class="countdown-label">DAYS</div>
									</div>
									<div id="countdown-hr">
										<div class="countdown-value">0</div>
										<div class="countdown-label">HOURS</div>
									</div>
									<div id="countdown-min">
										<div class="countdown-value">0</div>
										<div class="countdown-label">MINUTES</div>

									</div>
									<div id="countdown-sec">
										<div class="countdown-value">0</div>
										<div class="countdown-label">SECONDS</div>
									</div>
								</div>
								<div class="overlay-countdown-btn">
									<a class="content-btn tabs-btn countdown-predict-btn" data-tab-item="2" href="javascript:void(0)"><?php echo $prediction_settings['go_to_active_round_button'][0]; ?></a>
								</div>
							</div>
						</div>
						<?php } ?>
					</div>

					<div class="content-btn-container">
					<a class="content-btn tabs-btn pred-now" data-tab-item="2" href="javascript:void(0)"><?php echo $howitworks_settings['predict_now'][0]; ?></a>
						<div data-tab-item="7" class="tabs-btn terms"><?php echo $homepage_settings['terms_and_conditions'][0]; ?></div>
					</div>

				</div>
			</div>
		</div>
		
		<input type='hidden' id='home-url' value='<?php echo home_url(); ?>' />
		<input type='hidden' id='stylesheet-url' value='<?php echo get_stylesheet_directory_uri(); ?>' />
		<input type='hidden' id='timezone' value='<?php echo $timezone_settings['site_timezone'][0]; ?>' />
		<input type='hidden' id='current-datetime' value='<?php echo $current_date_format_iso; ?>' />
		<input type='hidden' id='default-leaderboard' value='<?php echo $leaderboard_settings['default_round'][0]; ?>' />
	
   		

	</main>

	<?php $fbanner_left_img_attr = wp_get_attachment_image_src($homepage_settings['floating_banners_left_image'][0], 'full'); ?>
    <?php $fbanner_right_img_attr = wp_get_attachment_image_src($homepage_settings['floating_banners_right_image'][0], 'full'); ?>

	

<?php get_footer(); ?>