<?php

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: set default to India Timezone
// @last update: 2019-02-20
//------------------------------------------------------------------------------
if(function_exists('date_default_timezone_set'))
{
   // if (get_timezone_settings()['site_timezone'][0] == "manila") {
        //date_default_timezone_set("Asia/Manila");
    //} else {
    //    date_default_timezone_set("Asia/Kolkata");  
    //}
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: de-register styles
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function dfl_remove_styles() {
	wp_dequeue_style('html5blank');
	wp_deregister_style('html5blank');
}

add_action('wp_enqueue_scripts', 'dfl_remove_styles', 25);

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: load html5blank child themes
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function dfl_styles() {
	if ($GLOBALS['pagenow'] != 'wp-login.php' && !is_admin()) {
		
		wp_register_style('jscrollpane-css', get_stylesheet_directory_uri() . '/css/jscrollpane/jquery.jscrollpane.css');
    	wp_enqueue_style('jscrollpane-css');

		wp_register_style('html5blank-child', get_stylesheet_directory_uri() . '/style.css');
		wp_enqueue_style('html5blank-child');

		wp_register_style('html5blank-child-responsive', get_stylesheet_directory_uri() . '/css/responsive.css');
		wp_enqueue_style('html5blank-child-responsive');

        
	}
}

add_action('wp_enqueue_scripts', 'dfl_styles');

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: load scripts
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function dfl_scripts() {
	if ($GLOBALS['pagenow'] != 'wp-login.php' && !is_admin()) {

		wp_register_script('jquery-mousewheel', get_stylesheet_directory_uri() . '/js/jscrollpane/jquery.mousewheel.min.js', '', '', true);
    	wp_enqueue_script('jquery-mousewheel');

		wp_register_script('jquery-jscrollpane', get_stylesheet_directory_uri() . '/js/jscrollpane/jquery.jscrollpane.min.js', '', '', true);
      	wp_enqueue_script('jquery-jscrollpane');

		wp_register_script('main-js', get_stylesheet_directory_uri() . '/js/main.js', '', '', true);
		wp_enqueue_script('main-js');

        wp_register_script('tracking-js', get_stylesheet_directory_uri() . '/js/tracking.js', '', '', true);
        wp_enqueue_script('tracking-js');
	}
}

add_action('init', 'dfl_scripts');

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve homepage settings
// @last update: 2020-08-14
//------------------------------------------------------------------------------
function get_footer_settings() {
    $footer_settings_page_id = get_page_by_path('footer');
    $footer_settings_page_id = $footer_settings_page_id -> ID;
    return get_post_meta($footer_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve homepage settings
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function get_homepage_settings() {
    $homepage_settings_page_id = get_page_by_path('home-page');
    $homepage_settings_page_id = $homepage_settings_page_id -> ID;
    return get_post_meta($homepage_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve how it works settings
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function get_howitworks_settings() {
    $howitworks_settings_page_id = get_page_by_path('how-it-works');
    $howitworks_settings_page_id = $howitworks_settings_page_id -> ID;
    return get_post_meta($howitworks_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve prediction bonus settings
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function get_predictionbonus_settings() {
    $predictionbonus_settings_page_id = get_page_by_path('prediction-bonus');
    $predictionbonus_settings_page_id = $predictionbonus_settings_page_id -> ID;
    return get_post_meta($predictionbonus_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve gadgets giveaway settings
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function get_gadgetsgiveaway_settings() {
    $gadgetsgiveaway_settings_page_id = get_page_by_path('gadgets-giveaway');
    $gadgetsgiveaway_settings_page_id = $gadgetsgiveaway_settings_page_id -> ID;
    return get_post_meta($gadgetsgiveaway_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve terms and conditions settings
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function get_termsconditions_settings() {
    $termsconditions_settings_page_id = get_page_by_path('terms-and-conditions');
    $termsconditions_settings_page_id = $termsconditions_settings_page_id -> ID;
    return get_post_meta($termsconditions_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve schedule settings
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function get_schedule_settings() {
    $schedule_settings_page_id = get_page_by_path('schedule');
    $schedule_settings_page_id = $schedule_settings_page_id -> ID;
    return get_post_meta($schedule_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve league-table settings
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function get_leaguetable_settings() {
    $leaguetable_settings_page_id = get_page_by_path('league-table');
    $leaguetable_settings_page_id = $leaguetable_settings_page_id -> ID;
    return get_post_meta($leaguetable_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve playoffs settings
// @last update: 2019-04-23
//------------------------------------------------------------------------------
function get_playoffs_settings() {
    $playoffs_settings_page_id = get_page_by_path('playoffs');
    $playoffs_settings_page_id = $playoffs_settings_page_id -> ID;
    return get_post_meta($playoffs_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve leaderboard settings
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function get_leaderboard_settings() {
    $leaderboard_settings_page_id = get_page_by_path('leaderboard');
    $leaderboard_settings_page_id = $leaderboard_settings_page_id -> ID;
    return get_post_meta($leaderboard_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve prediction settings
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function get_prediction_settings() {
    $prediction_settings_page_id = get_page_by_path('prediction');
    $prediction_settings_page_id = $prediction_settings_page_id -> ID;
    return get_post_meta($prediction_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve prediction bonus settings
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function get_gameweeks_settings() {
    $gameweeks_settings_page_id = get_page_by_path('game-weeks');
    $gameweeks_settings_page_id = $gameweeks_settings_page_id -> ID;
    return get_post_meta($gameweeks_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve registration popup  settings
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function get_registration_popup_settings() {
    $registration_popup_settings_page_id = get_page_by_path('registration-popup');
    $registration_popup_settings_page_id = $registration_popup_settings_page_id -> ID;
    return get_post_meta($registration_popup_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: retrieve registration popup  settings
// @last update: 2019-02-20
//------------------------------------------------------------------------------
function get_timezone_settings() {
    $timezone_settings_page_id = get_page_by_path('timezone');
    $timezone_settings_page_id = $timezone_settings_page_id -> ID;
    return get_post_meta($timezone_settings_page_id);
}

//------------------------------------------------------------------------------
// @author: dafaleague
// @description: custom post type 'Teams'
// @last update: 2019-02-20
//------------------------------------------------------------------------------
register_post_type('teams', array(
    'label' => __('Teams'),
    'public' => true,
    'show_ui' => true,
    'show_in_nav_menus' => true,
    'rewrite' => true,
    'capability_type' => 'post',
    'hierarchical' => true,
    'query_var' => true,
    'menu_position' => 6,
    'has_archive' => false,
    'menu_icon' => 'dashicons-groups',
    'supports' => array('title', 'editor')
    )
);

?>